﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO
Imports System.Data.SqlClient

Public Class MainForm

#Region " 窗体加载"
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        LoadValues()
    End Sub

    Private Sub LoadValues()
        ' 用一个枚举中的值的列表填充 ComboBox 
        cboDropDownStyle.DataSource = System.Enum.GetNames(GetType(ComboBoxStyle))
        cboDropDownStyle.DropDownStyle = ComboBoxStyle.DropDown
        ' 设置 cboDemo 的属性
        With nudDropDownWidth
            .Value = cboDemo.DropDownWidth
            .Minimum = cboDemo.Width
            .Maximum = cboDemo.Width * 2
        End With

        nudDropDownItems.Value = cboDemo.MaxDropDownItems
    End Sub
#End Region

#Region " <Add Items>（添加项）选项卡的代码 "
    Private Sub btnFill1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFill1.Click
        AddItems()
    End Sub

    Private Sub AddItems()
        ' 可以将项逐个添加到列表或组合框。
        ' 因为可以添加任何类型的对象，所以您可以决定
        ' 要显示对象的哪个属性。设置
        ' DisplayMember 属性以指示要显示的属性的名称。
        ' 在本例中，设置 DisplayMember 属性以显示 ProcessName
        ' 属性。

        ' ValueMember 属性仅在指定控件的 DataSource
        ' 属性时才起作用。

        Try
            Dim prc As Process
            ' 从控件中移除现有项。
            ' 注意，是清除 Items 集合，而不是 ListBox。
            lstProcessesAddItem.Items.Clear()

            ' 填充控件。指示应显示
            ' 添加到 ListBox.DataSource 的项的
            ' 哪个成员。
            lstProcessesAddItem.DisplayMember = "ProcessName"
            For Each prc In Process.GetProcesses
                lstProcessesAddItem.Items.Add(prc)
            Next
            lstProcessesAddItem.Sorted = True
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub lstProcessesAddItem_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstProcessesAddItem.SelectedIndexChanged
        ' 因为尚未设置控件的 DataSource 属性，无法
        ' 检索 SelectedValue 属性。因此，使用 SelectedItem 属性，
        ' 并显示所需的属性。
        Try
            ' 在尝试从列表读出项时，通常需要
            ' 验证是否已实际选择某个值。
            If lstProcessesAddItem.SelectedIndex > -1 Then
                lblFileName1.Text = CType(lstProcessesAddItem.SelectedItem, Process).MainModule.FileName
            Else
                lblFileName1.Text = String.Empty
            End If
        Catch ex As Exception
            ' 在本例中，发生异常时不执行任何操作。
            lblFileName1.Text = String.Empty
        End Try
    End Sub
#End Region

#Region " <Bind to DataTable>（绑定到 DataTable）选项卡的代码 "
    Private Sub btnFill2_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFill2.Click
        ' 将 ListBox 绑定到包含文件信息的 DataTable。 
        ' 此表很可能来自真实的数据源（如 SQL Server）。
        '  此外，还可以将 ListBox 或 ComboBox 绑定到许多其他 
        ' 数据源 -- 请参见"帮助"中的 IList 接口。
        Try
            Dim dt As DataTable = FillTable(My.Computer.FileSystem.SpecialDirectories.MyDocuments)

            If Not (dt Is Nothing) Then
                With lstFiles
                    .DisplayMember = "FileName"
                    .ValueMember = "Length"
                    .DataSource = dt
                End With
            Else
                lblFileInfo.Text = "Nothing in the array"
            End If

        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try

    End Sub

    ''' <summary>
    ''' 生成一个用有关硬盘上的文件的信息填充的 DataTable。
    ''' </summary>
    ''' <param name="path"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function FillTable(ByVal path As String) As DataTable
        Dim dt As New DataTable
        Dim dr As DataRow

        Try
            dt.Columns.Add("FileName", GetType(System.String))
            dt.Columns.Add("Length", GetType(System.Int64))

            ' 此方法使用 My 而不是直接使用 System.IO。
            For Each FilePath As String In My.Computer.FileSystem.GetFiles(path)
                dr = dt.NewRow
                dr("FileName") = My.Computer.FileSystem.GetFileInfo(FilePath).Name
                dr("Length") = My.Computer.FileSystem.GetFileInfo(FilePath).Length
                dt.Rows.Add(dr)
            Next
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try

        Return dt
    End Function

    Private Sub lstFiles_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstFiles.SelectedIndexChanged
        ' 显示所选文件的信息。
        ' ValueMember 属性设置为填充控件的 DataTable 
        ' 中的 Length 字段。
        If lstFiles.SelectedIndex > -1 Then
            lblFileInfo.Text = "Length: " & lstFiles.SelectedValue.ToString
        Else
            lblFileInfo.Text = String.Empty
        End If
    End Sub
#End Region

#Region " <Selection Mode>（选择模式）选项卡的代码 "
    Private Sub btnFill3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFill3.Click
        FillSelectionMode()
    End Sub

    Private Sub FillSelectionMode()
        Try
            With lstMultiSelect
                .DisplayMember = "Name"
                .ValueMember = "Length"
                .DataSource = My.Computer.FileSystem.GetDirectoryInfo(My.Computer.FileSystem.SpecialDirectories.MyDocuments).GetFiles()
                ' 初始化包含不同选择模式
                ' 的组合框：
                cboSelectionMode.Text = .SelectionMode.ToString
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub cboSelectionMode_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboSelectionMode.SelectedIndexChanged
        ' 使用户可以选择其中一个选择模式：
        ' One、MultipleSimple、MultipleExtended
        Try
            lstMultiSelect.ClearSelected()
            lstMultiSelect.SelectionMode = _
             CType(System.Enum.Parse(GetType(SelectionMode), cboSelectionMode.Text), _
             SelectionMode)

        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub lstMultiSelect_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstMultiSelect.SelectedIndexChanged
        ' 显示所选索引的列表。
        ' SelectedIndices 属性返回一个 SelectedIndexCollection
        ' 对象。使用其 CopyTo 方法将项复制到 
        ' 一个数组中，因此可以将该列表绑定到 ListBox 控件。
        Try
            Dim aIndices(lstMultiSelect.SelectedIndices.Count - 1) As Integer
            lstMultiSelect.SelectedIndices.CopyTo(aIndices, 0)
            lstSelected.DataSource = aIndices

            ' 演示如何"遍历"选定项列表。
            With lstSelectedItems
                .Items.Clear()
                ' Begin/EndUpdate 在您添加项时打开/关闭
                ' 控件的显示。只是使更新"更干净"。
                .BeginUpdate()
                Dim fi As FileInfo
                For Each fi In lstMultiSelect.SelectedItems
                    .Items.Add(fi.Name)
                Next
                .EndUpdate()
            End With
        Catch ex As Exception
            lstSelected.DataSource = Nothing
        End Try
    End Sub
#End Region

#Region " <Bind to Array>（绑定到数组）选项卡的代码"
    Private Sub btnFill4_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFill4.Click
        BindToArray()
    End Sub

    Private Sub BindToArray()
        ' 绑定到数组更简单 -- 只需设置 
        ' 控件的 DataSource 属性。在本例中，
        ' 还可以设置 ValueMember 属性：

        Try
            With lstProcessesDataSource
                .ValueMember = "MainModule"
                .DisplayMember = "ProcessName"
                .DataSource = Process.GetProcesses
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub lstProcessesDataSource_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstProcessesDataSource.SelectedIndexChanged
        ' 因为 ValueMember 属性设置为 MainModule，
        ' 所以可以检索控件的 SelectedValue 
        ' 属性。
        Try
            If lstProcessesDataSource.SelectedIndex > -1 Then
                lblFileName2.Text = CType(lstProcessesDataSource.SelectedValue, System.Diagnostics.Process).Modules(0).FileName
            Else
                lblFileName2.Text = String.Empty
            End If
        Catch ex As Exception
            ' 在本例中，发生异常时不执行任何操作。
            lblFileName2.Text = String.Empty
        End Try
    End Sub
#End Region

#Region " <ComboBox>（组合框）选项卡的代码 "

    Private Sub btnFill5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFill5.Click
        BindToDataSet()
    End Sub

    Private Sub BindToDataSet()
        Try
            LoadData()
            cboDemo.DataSource = Me.NorthwindDataSet.Employees
            cboDemo.DisplayMember = "FirstName"
            cboDemo.ValueMember = "EmployeeID"
            lblResults.Text = ""
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub LoadData()
        ' 显示一条状态消息，表明我们正尝试连接到 SQL Server。
        Dim statusForm As New Status()
        statusForm.Show("Connecting to SQL Server")

        ' 尝试先连接到本地 SQL Server 实例。  
        Try
            Me.EmployeesTableAdapter.Fill(Me.NorthwindDataSet.Employees)
            ' 已成功检索数据。
        Catch ex As Exception
            ' 不能连接到 SQL Server。
            Dim message As String = "To run this sample, you must have SQL " & _
            "Server with the Northwind database installed."
            MsgBox(message, MsgBoxStyle.OkOnly, Me.Text)
        End Try

        statusForm.Close()
    End Sub

    Private Sub cboDemo_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboDemo.SelectedIndexChanged
        If cboDemo.SelectedIndex > -1 Then
            lblResults.Text = cboDemo.SelectedValue.ToString
        Else
            lblResults.Text = String.Empty
        End If
    End Sub

    Private Sub cboDropDownStyle_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboDropDownStyle.SelectedIndexChanged
        Try
            ' 从组合框中检索枚举值， 
            ' 分析组合框中的文本。
            cboDemo.DropDownStyle = _
              CType(System.Enum.Parse(GetType(ComboBoxStyle), cboDropDownStyle.Text), _
                ComboBoxStyle)
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.OKOnly, Me.Text)
        End Try
    End Sub

    Private Sub nudDropDownItems_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles nudDropDownItems.ValueChanged
        cboDemo.MaxDropDownItems = CInt(nudDropDownItems.Value)
    End Sub

    Private Sub nudDropDownWidth_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles nudDropDownWidth.ValueChanged
        cboDemo.DropDownWidth = CInt(nudDropDownWidth.Value)
    End Sub
#End Region

#Region " BindingSource 的代码 "
    Private Sub BindingSourceFillButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BindingSourceFillButton.Click
        ' 使用 BindingSource 时，可以更改 BindingSource 的
        ' DataSource，而不必重置所有绑定的控件
        ' 在本例中，ComboBox 和两个文本框被重新绑定到 
        ' 新的列表
        Me.CustomerBindingSource.DataSource = GetCustomerList()
    End Sub
    ''' <summary>
    ''' 获取类型化 Customer 的集合
    ''' </summary>
    ''' <returns>返回 Customer 对象的类型化列表</returns>
    ''' <remarks>还可以使用 List(Of T)。BindingList(Of T) 提供其他可能会有用的事件</remarks>
    Private Function GetCustomerList() As System.ComponentModel.BindingList(Of Customer)
        ' 创建新的类型化客户列表
        Dim customerList As New System.ComponentModel.BindingList(Of Customer)
        ' 使用 Customer 构造函数将每个客户添加到列表
        customerList.Add(New Customer(1, "Alfreds Futterkiste"))
        customerList.Add(New Customer(2, "Ana Trujillo Emparedados y helados"))
        customerList.Add(New Customer(3, "Antonio Moreno Taquera"))
        customerList.Add(New Customer(4, "Around the Horn"))
        customerList.Add(New Customer(5, "Cactus Comidas para llevar"))

        ' 在本例中，我们只创建一个新客户，设置属性，
        ' 然后将该客户添加到类型化列表
        Dim newCustomer As New Customer()
        newCustomer.Id = 6
        newCustomer.Name = "Ernst Handel"
        customerList.Add(newCustomer)
        Return customerList
    End Function
#End Region

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

End Class
